#roloFlash 2, v06.*

! ***************************************************************************
! *
! *  Sample script for all targets
! *
! *  Task: Readout versions number etc. and write to LOG.TXT
! *
! *  Copyright (C) 2009-2020 by halec embedded solutions
! *
! ***************************************************************************


! For all files on the microSD card, the following applies:
!  - File name has to be in 8.3 format
!  - File name must contain only CAPITAL LETTERS
!  - (see manual, chapter "Files")


! ---- Preparations ----
! Delete old log file, if present
f = "LOG.TXT"
if fs_fileExists(0,f)
  fs_remove 0, f
endif

print "Running script copied from scripts/versions/ ...\r\n"

print "companyName=       ", sys_companyName, "\r\n"
print "deviceName=        ", sys_deviceName, "\r\n"
print "softwareVersion=   ", sys_softwareVersion, "\r\n"
print "hardwareVersion=   ", sys_hardwareVersion div $10000, ".", sys_hardwareVersion mod 65536, "\r\n"
print "bootloaderVersion= ", sys_bootloaderVersion div $10000, ".", sys_bootloaderVersion mod 65536, "\r\n"
print "imageVersion=      ", sys_imageVersion, "\r\n"
led_on 5, color_green
