#roloFlash 2

! ***************************************************************************
! *
! *  Beispiel-Skript fuer Microchip/Atmel-PDI-Controller
! *   
! *  Aufgabe: Chip loeschen, danach flashen
! *
! *  Copyright (C) 2009-2018 by halec embedded solutions
! *
! ***************************************************************************


! Fuer alle Dateien auf der SD-Karte gilt:
!  - Dateiname muss im 8.3-Format sein
!  - Dateiname muss komplett in GROSSBUCHSTABEN sein
!  - (siehe Handbuch, Kapitel "Dateien")


! *** Bitte an eigene Beduerfnisse anpassen! ***


targetName      = "ATXMEGA256A3U" ! Exakter Namen aus Handbuch, Kapitel
                                  ! "Spezifikation", uebernehmen
flashFile       = "FLASH.HEX"     ! "" angeben, wenn nicht benoetigt
eepromFile      = ""              ! "" angeben, wenn nicht benoetigt
busSpeed        = 100000          ! Bus-Geschwindigkeit in Hertz. 100 kHz sind
                                  ! eine konservative Wahl, um eine sichere
                                  ! Funktion auch bei niedrigem Target-CPU-Takt
                                  ! oder niedrigem roloFlash-CPU-Takt zu
                                  ! gewaehrleisten. Bei bekanntermassen
                                  ! hoeherem Target-CPU-Takt kann die Bus-
                                  ! Geschwindigkeit entsprechend erhoeht werden.
roloFlashHiSpeedMode = 0         ! 0 (false): circa 20mA@3.3V, ist langsamer
                                  ! 1 (true):  circa 80mA@3.3V, ist schneller

! Gruenes Lauflicht von LED 1 zu LED 4 -> symbolisiert Skript-Abarbeitung
! (Datenbertragungs-Richtung: schreibend)
! (LED 5 wird freigehalten fuer "Fertig"-Anzeige)
ledRunningLight 1, 4, COLOR_GREEN, 200


! ---- Vorbereitungen ----
! Evtl. altes Log loeschen
f = "LOG.TXT"
if fsFileExists(0,f)
  fsRemove 0, f
endif

! Software-Version des roloFlash und Skript-Namen in LOG.TXT schreiben
print "softwareVersion=", softwareVersion, "\r\n"
print "Running script copied from scripts/Microchip_Atmel/AVR/PDI/erase-and-flash/ ...\r\n"

! Falls roloFlashHiSpeedMode gewaehlt wurde, dann CPU-Takt des roloFlash auf
! Maximum setzen
if roloFlashHiSpeedMode
  setCpuClock CPU_CLOCKMAX
endif


! ---- Zugriff auf die im roloFlash befindliche Target-Datenbank  ----
dbHandle = DB_getHandle(targetName)

! ---- Atmel-PDI-Bus scannen ----
print "Scanning PDI ...\r\n"
busHandle = PDI_open(0, busSpeed)

! ---- Zugriff auf Target ----
print "Connecting to target ...\r\n"
family       = DB_get(dbHandle, DB_FAMILY)
targetHandle = getTargetHandle(busHandle, 0, family)
setTargetMode targetHandle, PROGRAMMODE

  
! ---- Device-ID pruefen ----
print "Checking device-ID ...\r\n"
expectedDeviceID = DB_get(dbHandle, DB_DEVICEID)
deviceID = getDeviceId(targetHandle)
if deviceID <> expectedDeviceID
  print "ERROR: Wrong controller detected\r\n"
  ! Abbruch
  throw USEREXCEPTION + 1
endif  

! ---- Target-Speicher-Parameter aus Target-Datenbank holen und benutzen ----
print "Getting target memory parameters from database ...\r\n"
flashSize = DB_get(dbHandle, DB_FLASHSIZE)
flashPageSize = DB_get(dbHandle, DB_FLASHPAGESIZE)
eepromSize = DB_get(dbHandle, DB_EEPROMSIZE)
eepromPageSize = DB_get(dbHandle, DB_EEPROMPAGESIZE)
print "  Target flash  size     [bytes]: ", flashSize, "\r\n"
print "  Target flash  pageSize [bytes]: ", flashPageSize, "\r\n"
print "  Target EEPROM size     [bytes]: ", eepromSize, "\r\n"
print "  Target EEPROM pagesize [bytes]: ", eepromPageSize, "\r\n"
setMemoryMap targetHandle, FLASH, MEM_SIZE, flashSize
setMemoryMap targetHandle, FLASH, MEM_PAGESIZE, flashPageSize
setMemoryMap targetHandle, EEPROM, MEM_SIZE, eepromSize
setMemoryMap targetHandle, EEPROM, MEM_PAGESIZE, eepromPageSize

! ---- Target loeschen ----
print "Erasing flash ...\r\n"
eraseFlash targetHandle 


! ---- Target-Flash schreiben ----
if flashFile <> ""
  print "Programming flash file ", flashFile, " ...\r\n"
  writeFileToTarget targetHandle, 0, flashFile, HEX, FLASH, WRITEVERIFY
else
  print "Flash programming skipped (no flash file specified)\r\n"
endif  

! ---- Target-EEPROM schreiben ----
if eepromFile <> ""
  print "Programming eeprom file ", eepromFile, " ...\r\n"
  writeFileToTarget targetHandle, 0, eepromFile, HEX, EEPROM, WRITEVERIFY
else
  print "EEPROM programming skipped (no EEPROM file specified)\r\n"
endif  

! ---- Nachbereitungen ----
closeTarget targetHandle
closeBus busHandle


! ---- Nach eventuell aufgetretener Exception schauen,         ----
! ---- Auswertung ins Log schreiben und per LEDs signalisieren ----
catch exception
print "Duration [ms]: ", getSystemTime(), "\r\n"
catch dummyException  ! Falls das letzte print eine Exception werfen sollte
if exception <> 0
  ! Es gab einen Fehler, diesen in LOG.TXT festhalten
  print "ERROR: Exception ", exception
  ! Nachdem die Exception mittels catch gefangen wurde, erneut setzen. Damit
  ! wird die Nummer der Exception ueber die LEDs durch Blinkcode angezeigt. Zu
  ! den Blinkcodes siehe Handbuch, Kapitel "Bedeutungen von LED-Codes",
  ! Unterkapitel "Exception aufgetreten".
  throw exception
else
  ! Fehlerfrei: ins Log schreiben und LED 5 auf gruen schalten
  print "Script ended successfully.\r\n"
  ledOn 5, COLOR_GREEN
endif

