#roloFlash 2

! ***************************************************************************
! *
! *  Beispiel-Skript fuer Microchip/Atmel-ISP-Controller
! *   
! *  Aufgabe: Hello world: LED leuchen, Schreiben von LOG.TXT
! *
! *  Copyright (C) 2009-2018 by halec embedded solutions
! *
! ***************************************************************************


! Fuer alle Dateien auf der SD-Karte gilt:
!  - Dateiname muss im 8.3-Format sein
!  - Dateiname muss komplett in GROSSBUCHSTABEN sein
!  - (siehe Handbuch, Kapitel "Dateien")


! ---- Vorbereitungen ----
! Evtl. altes Log loeschen
f = "LOG.TXT"
if fsFileExists(0,f)
  fsRemove 0, f
endif

! Software-Version des roloFlash und Skript-Namen in LOG.TXT schreiben
print "softwareVersion=", softwareVersion, "\r\n"
print "Running script copied from scripts/hello-world/ ...\r\n"

print "***************************************************\r\n"
print "*                                                 *\r\n"
print "* This LOG.TXT was written by roloFlash           *\r\n"
print "* This means, RUN.BAS was executed successfully   *\r\n"
print "*                                                 *\r\n"
print "* Your next steps are:                            *\r\n"
print "* - copy an other example from scripts/...        *\r\n"
print "*   to main folder of the microSD                 *\r\n" 
print "* - adapt this to your purpose                    *\r\n" 
print "* - run compile.bat --> RUN.BIN should be created *\r\n" 
print "* - remove safetly the microSD-card from the PC   *\r\n" 
print "* - put it into roloFlash                         *\r\n" 
print "* - connect roloFlash to the target               *\r\n" 
print "*                                                 *\r\n"
print "* Please also have a look at the doc-folder,      *\r\n"
print "* especially  doc/Quickstart-roloFlash-2-de       *\r\n"
print "*                                                 *\r\n"
print "***************************************************\r\n"

! Now a litte demonstration of red and green LEDs:

! 1. LEDs running green from top to bottom. You may use them for symbolisation
! of a flashing process.
ledRunningLight 1, 4, COLOR_GREEN, 200
! Just wait 1 second to show the LEDs. At this point you can do anything else
! while the LEDs are running at the same time.
delay 1000

! 2. The same with red LEDs... 
ledRunningLight 1, 4, COLOR_RED, 200
delay 1000

! 3. LEDs running green from top to bottom. You may use them for symbolisation
! of a reading process.
ledRunningLight 4, 1, COLOR_GREEN, 200
delay 1000

! 4. The same with red LEDs... 
ledRunningLight 1, 4, COLOR_RED, 200
delay 1000

! Make sure, all log messages are written to the micro-SDcard
setLogMode LOGMODE_IMMEDIATE


! 5. Just light the fifth green LED. You may use them for symbolisation
! for finished the work.
ledRunningLight 1, 4, COLOR_GREEN, 200

! ---- Nach eventuell aufgetretener Exception schauen,         ----
! ---- Auswertung ins Log schreiben und per LEDs signalisieren ----
catch exception
print "Duration [ms]: ", getSystemTime(), "\r\n"
catch dummyException  ! Falls das letzte print eine Exception werfen sollte
if exception <> 0
  ! Es gab einen Fehler, diesen in LOG.TXT festhalten
  print "ERROR: Exception ", exception
  ! Nachdem die Exception mittels catch gefangen wurde, erneut setzen. Damit
  ! wird die Nummer der Exception ueber die LEDs durch Blinkcode angezeigt. Zu
  ! den Blinkcodes siehe Handbuch, Kapitel "Bedeutungen von LED-Codes",
  ! Unterkapitel "Exception aufgetreten".
  throw exception
else
  ! Fehlerfrei: ins Log schreiben und LED 5 auf gruen schalten
  print "Script ended successfully.\r\n"
  ledOn 5, COLOR_GREEN
endif

